#include <iostream>

#include <memory.h>

#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/SoftwareMixer.h>

#include <sys/times.h> // times -- SVr4, SVID, POSIX, X/OPEN, BSD 4.3
#include <time.h>      // CLOCKS_PER_SEC
int main(int argc, char** argv)
{
     using pp::internal::SoftwareMixer::MixStereoUnrolled;
     using pp::internal::SoftwareMixer::MixStereo;
#define MixSXU MixStereoUnrolled<int16_t, int32_t, 10>
#define MixSX  MixStereo<int16_t, int32_t, 10>


#if 0
     const size_t LENGTH = 0x100;
     typedef u_int8_t In;
     u_int8_t in[LENGTH];
     for (int i = 0; i < LENGTH; ++i)
       in[i] = i;
#else
     const size_t LENGTH = 0x10000;
     typedef int16_t In;
     int16_t in[LENGTH];
     for (int i = 0; i < LENGTH; ++i)
          in[i] = i;
#endif

     const int LOOPS = 1;
  // int8_t   in[5];
     int32_t  out[LENGTH*2];


     memset(out, 0, sizeof(out));
     pp::internal::Fixed position;
     pp::internal::Fixed scale(1.0);

     tms start1;
     tms end1;
     tms start2;
     tms end2;

     times(&start2);
     for (int x = 0; x < LOOPS; ++x)
          {
               memset(out, 0, sizeof(out));
               for (int i = 0; i < 16; ++i)
                    {
                         position = 0.0;
                         MixSX(LENGTH, 64, 32, scale, position, in, out);
                    }
          }
     times(&end2);


     cout << "Normal: User: "
          << end2.tms_utime  -  start2.tms_utime
          << " System: "
          << end2.tms_stime  -  start2.tms_stime
          << " Child User: "
          << end2.tms_cutime -  start2.tms_cutime
          << " Child System: "
          << end2.tms_cstime -  start2.tms_cstime
          << endl;


     times(&start1);

     for (int x = 0; x < LOOPS; ++x)
          {

               memset(out, 0, sizeof(out));
               for (int i = 0; i < 16; ++i)
                    {
                         position = 0.0;
                         MixSXU(LENGTH, 64, 32, scale, position, in, out);
                    }

          }

     times(&end1);

     cout << "Unrolled: User: "
          << end1.tms_utime  -  start1.tms_utime
          << " System: "
          << end1.tms_stime  -  start1.tms_stime
          << " Child User: "
          << end1.tms_cutime -  start1.tms_cutime
          << " Child System: "
          << end1.tms_cstime -  start1.tms_cstime
          << endl;


#if 1
     //      }
     for (unsigned long i = 0; i < LENGTH; ++i)
          {
               std::cout << std::hex
                         << (In)in[i]
                         << " : ["
                         << (long)out[i*2]
                         << ", "
                         << (long)out[i*2+1]
                         << "]"
                         << std::endl;
          }
#endif
     return 0;
}

/*

     u_int8_t int8_t u_int16_t int16_t  u_int32_t     int32_t

 max     0xff   0x7f    0xffff  0x7fff 0xffffffff  0x7fffffff
         0xc0   0x40    0xc000  0x4000 0xc0000000  0x40000000
 mid     0x80   0x00    0x8000  0x0000 0x80000000  0x00000000
         0x40  -0xc0    0x4000 -0xc000 0x40000000 -0xc0000000
 min     0x00  -0x80    0x0000 -0x8000 0x00000000 -0x80000000

     u_int8_t int8_t u_int16_t int16_t  u_int32_t     int32_t

 max      255    127     65535   32767 4294967295  2147483647
          192     64     49152   16384 3221225472  1073741824
 mid      128      0     32768       0 2147483648           0
           64    -64     16384  -16384 1073741824 -1073741824
 min        0   -128         0  -32768          0 -2147483648


*/
