//=============================================================================
// $Id: test.cpp,v 1.1.1.1 1999/11/06 11:54:01 creinig Exp $
//-----------------------------------------------------------------------------
// $Log: test.cpp,v $
// Revision 1.1.1.1  1999/11/06 11:54:01  creinig
// Back in CVS at last
//
//=============================================================================
#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/PenguinSound.h>
#include <iostream>

#ifndef WIN32
#include <getopt.h>
#endif

bool speedset = false;
bool raw      = false;
long speed    = 0;
int  id       = -1;

using namespace std;

void getoptions(int count, char** argument);
void usage(char* filename);

int main(int argc, char** argv)
{
  if (argc <= 1)
    {
      usage(argv[0]);
      exit(1);
    }

#ifndef WIN32
  getoptions(argc, argv);
  int j = optind;
#else
  int j = 1;
#endif

  pp::Audio* driver = 0;

  try
    {
      driver = pp::Audio::Create(id);
    }
  catch (...)
    {
      cerr << "error creating audio driver" << endl;
      exit (1);
    }

#if 1
  // allocate a channel and start it so the mixer thread
  // doesn't start end stop with each new sample
  pp::Channel* c = driver->AllocateChannel();
  c->Start();
#endif


  for (; j < argc; j++)
    {
      cout << "Loading "<< argv[j] <<" . . ." << endl;

      pp::Sample* s = 0;

      if (raw)
        {
          s = new pp::internal::SampleRaw;
          s->Load(argv[j]);
        }
      else
        {
          s = pp::Sample::LoadByFactory(argv[j]);
        }

      if (!s)
        {
          cerr << "Error loading " <<  argv[j] << endl;
          continue;
        }

      // what about displaying information about the sample?
      if (speedset)
        s->SetFrequency(speed);


      driver->Play(*s);
      delete s;
      s = 0;
    }
  delete driver;
  driver = 0;

  return 0;
}

void getoptions(int count, char **argument)
{
#ifndef WIN32
  // get the options
  while (1)
    {
      int option_index = 0;
      int c;
      static struct option long_options[] =
      {
        {"driver",    1, 0, 'd'},
        {"frequency", 1, 0, 'f'},
        {"help",      0, 0, 'h'},
        {"raw",       0, 0, 'r'},
        {0,           0, 0,   0}
      };

      c = getopt_long (count, argument, "hd:f:r", long_options, &option_index);
      if (c == -1)
        break;

      switch (c)
        {
        case 'd':
          cout << "driver : " << optarg << endl;
          /* convert the string to a long integer */
          id = strtol(optarg,0,10);
          break;

        case 'h' :
          usage(argument[0]);
          break;

        case 'f' :
          cout << "frequency : " << optarg << endl;
         /* convert the string to a long integer */
         speedset = true;
         speed = strtol(optarg,0,10);
         break;

        case 'r':
          raw = true;
          break;

        default:
          cerr << "?? getopt returned character code 0"<< c <<"??" << endl;
      }
    }
#endif
}

void usage(char *filename)
{
  cout << "Usage : " << filename << " [flags] <audio_file>" << endl;
  cout << "Options :" << endl;
  cout << "  -h|--help              display help" << endl;
  cout << "  -f|--frequency <value> set playback rate to <value>" << endl;
  cout << "  -d|--driver    <id>    use the driver with the given id" <<endl;
}
