#include <string>
#include <iostream>

#include <PenguinPlay/PenguinPlay.h>

#include <PenguinPlay/Factory.h>
#include <PenguinPlay/FileExtension.h>

#include <PenguinPlay/Sample.h>
#include <PenguinPlay/SampleAu.h>
#include <PenguinPlay/SampleIff.h>
#include <PenguinPlay/SampleRaw.h>
#include <PenguinPlay/SampleVoc.h>
#include <PenguinPlay/SampleWav.h>
#ifdef   PP_HAVE_AUDIOFILE_H
#include <PenguinPlay/SampleAF.h>
#endif

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

typedef RegistryFactory<Sample, std::string> SampleRegistry;

void RegisterSamples()
{
     SampleRegistry* r = SampleRegistry::Instance();
     (*r)["au"]        = new Factory<Sample, SampleAu>;
     (*r)["iff"]       = new Factory<Sample, SampleIff>;
     (*r)["raw"]       = new Factory<Sample, SampleRaw>;
     (*r)["voc"]       = new Factory<Sample, SampleVoc>;
     (*r)["wav"]       = new Factory<Sample, SampleWav>;
#ifdef   PP_HAVE_AUDIOFILE_H
     static Factory<Sample, SampleAF> afFactory;
     (*r)["aif"]       = &afFactory;
     (*r)["aiff"]      = &afFactory;
     (*r)["aifc"]      = &afFactory;
#endif
}

Sample* Sample::LoadByFactory(const char* filename)
{
     Sample*         ret = 0;
     SampleRegistry* r   = SampleRegistry::Instance();

     if (r->empty())
          RegisterSamples();

     try
          {
               ret = r->Create(GetExtension(filename));

               if (ret)
                    {
                         if (!ret->Load(filename))
                              {
                                   ppThrow (EAccessFailure, "Load Failed.");
                              }
                    }
          }
     catch (Exception &message)
          {
               ppWarning ("Exception caught: %s (%s) in %s",
                          message.Type (), message.Details (), message.Origin ());
               delete ret;
               ret = 0;
          }
     return ret;
}

bool Sample::SaveByFactory(const char*   filename,
                           const Sample& sample)
{
     SampleRegistry* r     = SampleRegistry::Instance();
     Sample*         saver = 0;
     bool               ret   = false;

     if (r->empty())
          RegisterSamples();

     saver = r->Create(GetExtension(filename));

     if (saver)
          {
               ret = saver->Save(filename, sample);
               delete saver;
               saver = 0;
          }

     return ret;
}

bool Sample::AllocateDataLengthMono(int length)
{
     if (m_data0 != 0)
          {
               delete [] m_data0;
               m_data0 = 0;
          }
     m_data0 = new unsigned char [length];
     m_length = length;

     return m_data0 != 0;
}

bool Sample::AllocateDataLength(int length)
{
     if (m_data1 != 0)
          {
               delete [] m_data1;
               m_data1 = 0;
          }
     m_data1 = new unsigned char [length];

     return (m_data1 != 0) && AllocateDataLengthMono(length);
}

/// convert 16 bit samples from big endian to little endian or vice versa
/// Not Yet Coded. I'll get around to doing it sometime later.
void Sample::SwapBytes()
{
     if (m_data0 != 0)
          {

          }
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END
