#include <PenguinPlay/Mutex.h>

#ifdef PP_SYS_OS_WIN32
#include <windows.h>
#else
#include <pthread.h>
#endif /* PP_SYS_OS_WIN32 */

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

#ifdef PP_SYS_OS_WIN32

class Mutex::MutexPrivate
{
public:
   MutexPrivate();
   ~MutexPrivate();

   bool Lock();
   bool TryToLock();
   bool Unlock();

private:

   HANDLE          m_mutex;
   };

//============================================================================
//
//============================================================================
Mutex::MutexPrivate::MutexPrivate()
   {
   m_mutex = CreateMutex(NULL, FALSE, NULL);
   }

//============================================================================
//
//============================================================================
Mutex::MutexPrivate::~MutexPrivate()
   {
   CloseHandle(m_mutex);
   }

//============================================================================
//
//============================================================================
bool Mutex::MutexPrivate::Lock()
   {
   return (WaitForSingleObject(m_mutex, INFINITE) == WAIT_OBJECT_0);
   }

//============================================================================
//
//============================================================================
bool Mutex::MutexPrivate::TryToLock()
   {
   return (WaitForSingleObject(m_mutex, 0) == WAIT_OBJECT_0);
   }


//============================================================================
//
//============================================================================
bool Mutex::MutexPrivate::Unlock()
   {
   ReleaseMutex(m_mutex);
   return true;
   }

#else /* PP_SYS_OS_WIN32 */

class Mutex::MutexPrivate
{
public:
   MutexPrivate();
   ~MutexPrivate();

   bool Lock();
   bool TryToLock();
   bool Unlock();

private:
   pthread_mutex_t          m_mutex;
   };

//============================================================================
//
//============================================================================
Mutex::MutexPrivate::MutexPrivate()
   {
   pthread_mutex_init(&m_mutex, 0);
   }

Mutex::MutexPrivate::~MutexPrivate()
   {
   pthread_mutex_destroy(&m_mutex);
   }

bool Mutex::MutexPrivate::Lock()
   {
   return (pthread_mutex_lock(&m_mutex) == 0);
   }

bool Mutex::MutexPrivate::TryToLock()
   {
   return (pthread_mutex_trylock(&m_mutex) == 0);
   }

bool Mutex::MutexPrivate::Unlock()
   {
   return (pthread_mutex_unlock(&m_mutex) == 0);
   }
#endif /* PP_SYS_OS_WIN32 */

//============================================================================
//
//============================================================================
Mutex::Mutex()
   {
   m_private = new MutexPrivate;
   }

//============================================================================
//
//============================================================================
Mutex::~Mutex()
   {
   delete m_private;
   }

//============================================================================
//
//============================================================================
bool Mutex::Lock()
   {
   return m_private->Lock();
   }

//============================================================================
//
//============================================================================
bool Mutex::TryToLock()
   {
   return m_private->TryToLock();
   }


//============================================================================
//
//============================================================================
bool Mutex::Unlock()
   {
   return m_private->Unlock();
   }

PP_I_NAMESPACE_END
PP_NAMESPACE_END