#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/FileAudio.h>

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef PP_HAVE_UNISTD_H
#include <unistd.h>
#endif

//#ifdef PP_DEBUG
//#include <iostream>
//#endif

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN


FileAudio::FileAudio(int               rate,
                     int               bits,
                     bool              stereo,
                     const std::string filename)
{
     m_rate   = rate;
     m_bits   = bits;
     m_stereo = stereo;
     if (!Create(filename))
          ppThrow (EAccessFailure, "Can't create audio output file!");
}

FileAudio::FileAudio(int  filedescriptor,
                     int  rate,
                     int  bits,
                     bool stereo)
{
     m_rate   = rate;
     m_bits   = bits;
     m_stereo = stereo;
     if (!Create(filedescriptor))
          ppThrow (EAccessFailure, "Can't create audio output file!");
}


FileAudio::~FileAudio()
{
     try
          {
               Destroy();
          }
     catch(...)
          {
          }
}

bool FileAudio::Create(int filedescriptor)
{
     if (filedescriptor == -1)
          return false;
     m_fd = filedescriptor;

     struct stat st;
     fstat(m_fd, &st);
     m_buffer_size = st.st_blksize;

     m_audio_buffer = new unsigned char [m_buffer_size];

     ppDebug1 ("File Audio %d bit %d Hz %s",
	       m_bits, m_rate, (m_stereo ? "stereo" : "mono"));

     return m_audio_buffer != 0;
}

bool FileAudio::Create(const std::string& filename)
{
     int fd = open(filename.c_str(), O_WRONLY | O_CREAT, S_IREAD | S_IWRITE);
     if (fd == -1) return false;

     ppDebug1 ("File Audio %s", filename.c_str ());

     return Create(fd);
}

void FileAudio::Destroy()
{
     if (m_fd != -1)
          {
               close(m_fd);
               m_fd = -1;
          }
     if (m_audio_buffer)
          {
               delete [] m_audio_buffer;
               m_audio_buffer = 0;
          }
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END
