#include <PenguinPlay/PenguinPlay.h>
#include <PenguinPlay/Esd.h>

#ifndef PP_HAVE_ESD_H
PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN
Esd::Esd(int, int, bool)
{
      ppThrow (EUnsupportedEnvironment,
               "Esd support was not compiled in to PenguinSound.");
}

Esd::~Esd() { }
PP_I_NAMESPACE_END
PP_NAMESPACE_END
#else /* PP_HAVE_ESD_H */

#include <esd.h>
#include <stdio.h>  // sprintf
#include <unistd.h> // close
#include <dlfcn.h>  // dlopen, dlsym, dlerror, dlclose

//#ifdef PP_DEBUG
//#include <iostream>
//#endif

PP_NAMESPACE_BEGIN
PP_I_NAMESPACE_BEGIN

/*
    A class to hold details to do with creating the Esd connection
*/
class EsdPrivate
{
public:
     EsdPrivate() : m_handle(0), m_esd_play_fn(0) {}
     ~EsdPrivate();
     bool LoadPlayFunction();

     typedef int (*esd_play_fn)(int, int, char*, char*);

     void* m_handle;
     esd_play_fn m_esd_play_fn;
};

EsdPrivate::~EsdPrivate()
{
     try
          {
               if (m_handle != 0)
                    {
                         dlclose(m_handle);
                         m_handle = 0;
                         m_esd_play_fn = 0;
                    }
          }
     catch(...)
          {
          }
}

bool EsdPrivate::LoadPlayFunction()
{
     m_esd_play_fn = (esd_play_fn)dlsym(m_handle, "esd_play_stream_fallback");
     return m_esd_play_fn != 0;
}

Esd::Esd(int rate, int bits, bool stereo)
{
     m_private = new EsdPrivate;

     int esd_bits;
     int esd_channels;
     int format;
     char* host = getenv("ESPEAKER");

     if (host == 0)
          host = "localhost";

     m_private->m_handle = dlopen("libesd.so", RTLD_LAZY);

     if (m_private->m_handle == 0)
          ppThrow (EAccessFailure, "Can't open libesd.so");

     if (!m_private->LoadPlayFunction())
          ppThrow (EUnsupportedEnvironment, "Can't find esd_play_stream_fallback in libesd.so");

     if (bits == 16)
          {
               esd_bits = ESD_BITS16;
               m_bits = 16;
          }
     else
          {
               esd_bits = ESD_BITS8;
               m_bits = 8;
          }

     if (stereo)
          esd_channels = ESD_STEREO;
     else
          esd_channels = ESD_MONO;

     m_stereo = stereo;

     m_rate = rate;

     m_buffer_size = ESD_BUF_SIZE;// divide by 8

     format = esd_bits | esd_channels | ESD_STREAM | ESD_PLAY;
     // need to get something to use as a name
     // something unique to each application
     // "psound" concatenated with the time should do

     time_t now = time(0);
     char name[25];
     sprintf(name, "psound%ld", now);

     m_fd = m_private->m_esd_play_fn(format, rate, host, name);

     if (m_fd <= 0)
          ppThrow (EAccessFailure, "esd_play_stream_fallback failed.");

     m_audio_buffer = new unsigned char [m_buffer_size];

     ppDebug1 ("EsounD %s %d bit %d Hz %s on %s",
	       name, m_bits, m_rate, (m_stereo ? "stereo" : "mono"), host);
}

Esd::~Esd()
{
     try
          {
               delete m_private;
          }
     catch (...)
          {
          }
}

PP_I_NAMESPACE_END
PP_NAMESPACE_END
#endif
