#include <iostream.h>
#include <fstream.h>
#include <unistd.h>
#include <String.h>
#include "String.String.AVLMap.h"

#include "webpage.h"

CORBA::Boolean operator>>=( const CORBA::Any &a, String &s ){
  char * cs;
  if(a>>=cs){
    s=cs;
    return true;
  }
  return false;
}

class   Map : public StringStringAVLMap {

private:

  char subSep;

public:

  char getSubSep();
  void setSubSep(char newSubSep);

  String& Map::operator () (String  item);
  String& Map::operator () (String  item1, String item2);
  String& Map::operator () (String  item1, String item2, String item3);
};

Map::Map() :StringStringAVLMap(){
  setSubSep(';');
}

Map::Map(Map& b) :StringStringAVLMap(b.def){
  setSubSep(';');
}

String& Map::operator () (String  item){
  return (*this)[item];
}

String& Map::operator () (String  item1, String item2){
  return (*this)[item2+subSep+item1];
}

String& Map::operator () (String  item1, String item2, String item3){
  return (*this)[item3+subSep+item2+subSep+item1];
}

char Map::getSubSep(){
  return subSep; 
}

void Map::setSubSep(char newSubSep){ 
  subSep=newSubSep;
}

const String defaultTag="CocoTag";

const Regex tagPre("[ \n\t]*<[ \n\t]*"+defaultTag+"[ \n\t]+name=",true);
const Regex tagPost("[ \n\t]*>[ \n\t]*",true);


class WebPage_impl : virtual public WebPage_skel {

private:

  CORBA::Long counter;

  Map tagMap;
  
  String buildTag(String s){
    return buildTag(defaultTag,s);
  }
  
  String buildTag(String tag, String s){
    if(s==NULL)
      s="NULL";
    return   "<"+tag+" name="+s+">\n";
  }

  CORBA::Boolean restore(){
    String s="data/", c;
    ifstream inp (s+getName());
    if(inp!=NULL){
      String i;
      inp >>i;
      do{
	c+=i;
     	inp>>i;
	if(inp.eof())
	  break;
	c+='\n';
      }while(1);

      setContent(c);
      counter=strtol(tagMap("COUNTER"), (char **)NULL, 10);
      cout << "restored >>>" << getName() << "<<<"<< endl;      
      return TRUE;
    }
    return FALSE;
  }
  
public:
  
  WebPage_impl (const CORBA::BOA::ReferenceData &refdata)
    : WebPage_skel (refdata)
    {
      if(!restore()){
	counter=0;
      }

    }

  WebPage_impl (String s) :WebPage_skel ((CORBA::ORB::ObjectTag_var) 
					 CORBA::ORB::string_to_tag (s))
    {
      tagMap("NAME")=s;
      if(!restore()){
	counter=0;
      }
      loadContainees();

    }
  
  WebPage_impl (CORBA::Object_ptr obj)
    : WebPage_skel (obj)
    {
      cout << " restoring via obj " << endl;
      assert(restore());
      CORBA::BOA_var boa = _boa();
      CORBA::BOA::ReferenceData_var id = boa->get_id (this);
      CORBA::String_var str = CORBA::ORB::tag_to_string (id);
      cout << "ReferenceData = " << str << endl;
    }
  
  ~WebPage_impl(){
  }

  CORBA::Boolean _save_object ()
    {
      String s="data/";
      cout << "saving " << getName() << endl;
      ofstream out (s+getName());
      assert (out);
      //	out << counter;
      for(Pix p=tagMap.first(); p; tagMap.next(p) )
	out  << buildTag(tagMap.key(p)) << tagMap.contents(p)<< "\n";

      return TRUE;
    }

  void shutdown ()
    {
      CORBA::BOA_var boa = _boa();
      boa->deactivate_impl (CORBA::ImplementationDef::_nil());
    }
  
  CORBA::ULong getContentType(CORBA::Any *&a){
    a=new CORBA::Any();
    char * s="text/html";
    *a<<=s;
    return strlen(s)+1;
  }
  
  CORBA::ULong setContent(const CORBA::Any &a, long int len){
    String buffer;
    a>>=buffer;
    return setContent(buffer);
  }
  
  CORBA::ULong setContent(const String &content) {
    String tagName, tagContent;
    int i, ntags;
    if(content=="")
      ntags=0;
    else{
      String tags[ntags=content.freq(defaultTag)+1];
      ntags=split(content,tags,ntags+1,tagPre);
      tagMap("START")=tags[0];
      for(i=1; i<ntags ; i++) {
	tagName=tags[i].before(tagPost);
	tagContent=tags[i].after(tagPost);
	tagMap(tagName)=tagContent;
      }
    }
    
  }


  CORBA::ULong getContent(const char * cs, CORBA::Any *&a){
    
    a=new CORBA::Any();
    
    String s(cs), result=cocoTag("START","");;

    int nampersands=s.freq('&');
    Map argMap;
   
    if(s!=""){
      int i, argc=nampersands+1;
      String names[argc], value;
      split(s,names,argc,'&');
      for(i=0; i<argc; i++){
	value=names[i].after('=');
	argMap[names[i].before('=')]=value;
      }
    }
    
    webContent(argMap,result);
    *a<<=result;

    return result.length()+1;
  }

  const String cocoTag( const String s ){
    return buildTag(s);
  }
  
  const String cocoTag( const String &s, 
			const String &i  ) {
    String t=tagMap(s);
    if(t!="")
      return buildTag(s)+t;
    else{
      tagMap(s)=i;
      return buildTag(s)+i;
    }
  }

  const String cocoProtectedTag( const String &s, 
				 const String &i  ) {
    String t=(tagMap(s)=i);
    return buildTag(s)+t;
  }

  String htmlMap(Map &m) {
    String result;
    for(Pix p=m.first(); p; m.next(p) )
      result+=m.key(p)+ "=" +m.contents(p)+ "<br>\n";
    return result;
  }

  void loadContainees() {
    for(Pix p=tagMap.first(); p; tagMap.next(p) ){
      String keys[2];
      int ntags=split(tagMap.key(p),keys,2,tagMap.getSubSep());
      if(keys[0]=="cont" && tagMap.contents(p)=="creatorOf"){
	createWebPage(keys[1],false);
      }
    }
  }

  String htmlLinks() {
    String result;

    for(Pix p=tagMap.first(); p; tagMap.next(p) ){
      String keys[2];

      int ntags=split(tagMap.key(p),keys,2,tagMap.getSubSep());
      if(keys[0]=="cont"){

	String name;
	CORBA::Object_var obj=getObjectByName(keys[1]);

	WebPage_var client = WebPage::_narrow(obj); 

	name=client->getName(); 
	result+="<A HREF=\"" +name+"\">"+name+", "+keys[1]+"</A><br>\n";

      }
    }

    return result;
  }

  char * returnString(String &rs){
    char * s=(char *) malloc(rs.length()+1);
    strcpy(s,rs.chars());
    return s;
  }

  char * getName(){
    return returnString(tagMap("NAME"));
  }

  void getTag(const char * tagName, char *& tagContent){
    tagContent=returnString(tagMap(tagName));
  }

  char * getRelation(const char * toWhom){
    return returnString(tagMap(toWhom,"cont"));
  }
  
  void setRelation(const char * toWhom, const char * name){
    tagMap(toWhom,"cont")=name;
  }
  
  CORBA::Object_var getObjectByName(const String &name){
    CORBA::ORB::ObjectTag_var tag = 
      CORBA::ORB::string_to_tag (name);

    return _orb()->bind ("IDL:WebPage:1.0",tag);//"local:");
  }

  void createWebPage(const String &name, bool setRelation=true){
    WebPage_var client;

    CORBA::Object_var obj=getObjectByName(name);

    if(CORBA::is_nil (obj)){

      WebPage_ptr acc= new WebPage_impl (name);
      client = WebPage::_narrow(acc); 
      if(setRelation){
	tagMap(name,"cont")="creatorOf";
	client->setRelation(getName(),"createdBy");
      }

    }else{
	  
      client = WebPage::_narrow(obj);
      if(setRelation){
	tagMap(name,"cont")="containerOf";
	client->setRelation(getName(),"containedBy");
      }
    }
  }


  void webContent(Map &argMap, String &result) {
    int i;
    char buffer[20];
    
    result+=
      cocoTag("HEADER","<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">
<HTML>
<HEAD>
<TITLE>Corba Commander 0.5 output
</TITLE>
</HEAD>
<BODY>
");
    for(Pix p=argMap.first(); p; argMap.next(p) ) {
      if( argMap.key(p)=="cmd" && argMap.contents(p)=="shutdown") {
	shutdown();
	result+=cocoTag("SHUTDOWNMESSAGE","<H1><blink>WebSite going down!</blink></H1>
<A HREF=\""+tagMap("NAME")+"\">try again</A>");
      }
      if( argMap.key(p)=="cmd" && argMap.contents(p)=="create")
	createWebPage(argMap("name"));
    }
    // normal call, without cmd
    if(argMap("cmd")!="shutdown"){
      String maps=(htmlMap(argMap)+"\n"+htmlMap(tagMap)),
	links=htmlLinks();
      maps.gsub("<","&lt;");
      maps.gsub(">","&gt;");
      
      sprintf(buffer,"%ld",counter++);
      result+=cocoTag("TOP","Hello World ")
	+cocoProtectedTag("COUNTER",buffer);
      sprintf(buffer,"%ld",getpid());
      result+=cocoProtectedTag("PID",buffer) 
	+cocoTag("ARGLIST","<br>
<H5><PRE>"
		 +maps+"</PRE></H5>")+
	cocoProtectedTag("CONTAINEES",links)+
	cocoTag("FORM","<FORM ACTION=\"/coco/"+tagMap("NAME")+"\">
<P>
<INPUT NAME=name SIZE=50><br> 
<input NAME=cmd TYPE=submit VALUE=shutdown>
<input NAME=cmd TYPE=submit VALUE=create>
<input NAME=cmd TYPE=submit VALUE=reload>
</FORM>
");
    }
    result+=cocoTag("FOOTER","</BODY>
</HTML>
");

  }
};

/*
 * WebPage object restorer
 */

/*class WebPageLoader : public CORBA::BOAObjectRestorer {
  public:
  CORBA::Boolean restore (CORBA::Object_ptr obj)
{
cout << "trying restore " << obj->_repoid() << " objects" << endl;
if (!strcmp (obj->_repoid(), "IDL:WebPage:1.0")) {
new WebPage_impl (obj);
return TRUE;
}
cout << "cannot restore " << obj->_repoid() << " objects" << endl;
return FALSE;
}
};
*/

int main( int argc, char *argv[] ) {
  //WebPageLoader loader;

  CORBA::ORB_var orb;
  CORBA::BOA_var boa;
  
  orb = CORBA::ORB_init( argc, argv, "mico-local-orb" );
  boa = orb->BOA_init (argc, argv, "mico-local-boa");

  char * root;
  if(argc==2)
    root=argv[1];
  else
    root="root.html";
  //  if (!boa->restoring()) {
    //    CORBA::ORB::ObjectTag_var tag = CORBA::ORB::string_to_tag ();
  //WebPage_ptr acc = new WebPage_impl ("foobar.html");
    //tag = CORBA::ORB::string_to_tag ();
     new WebPage_impl (root);
     // new WebPage_impl ("foo.html");
    //}
  
  boa->impl_is_ready (CORBA::ImplementationDef::_nil());
  
  return 0;
}
