#include "String.h"

extern "C" {
#include "httpd.h"
#include "http_main.h"
#include "http_protocol.h"
#include "mod_coco.h"
}

#include "webpage.h"
#include "fastcharbuf.h"

/*
 * init Corba for the special configuration record
 */
class CoCoCorba{

public:

  CORBA::ORB_var orb ;
  CORBA::BOA_var boa ;

  CoCoCorba(coco_config * cfg){
    orb = CORBA::ORB_init( cfg->argc, cfg->argv, "mico-local-orb" );
    boa = orb->BOA_init (cfg->argc, cfg->argv, "mico-local-boa");
    next=NULL;
    bindingStart=NULL;
    bindingLast=&bindingStart;
  }

  CoCoCorba * next;
  
  class Bind{
  public:
    Bind (String t,String a){
      type=t;
      address=a;
      next=NULL;
    }
    String type, address;
    Bind * next;
  };
  
  Bind * bindingStart, ** bindingLast;
  
  int request(request_rec *r, coco_config *cfg){
    CORBA::ORB::ObjectTag_var tag = CORBA::ORB::string_to_tag (r->path_info+1);
    CORBA::Object_var obj;

    /*
     * find a server
     */
    int hasFound;
    Bind * bindingRun;
    for( hasFound=0, bindingRun=bindingStart; 
	 !hasFound && bindingRun!=NULL; 
	 bindingRun=bindingRun->next){
      for(int i=0; !hasFound && i< 10 ; i++){
	obj= orb->bind (bindingRun->type,tag, bindingRun->address);
	hasFound |= !CORBA::is_nil (obj) ;
      }
    }

    if(!hasFound)
      return HTTP_NOT_FOUND; // no server found
    else{
      WebPage_var client = WebPage::_narrow( obj ); // create web object

      CORBA::Any *any;

      if(r->method_number==M_PUT){
	long actlen, buflen=10000;
	char buffer[buflen+1];

	int ret=setup_client_block(r,REQUEST_CHUNKED_PASS);

	CORBA::Any putAny;

 	fastCharBuffer charBuf(2*buflen);

	if(ret)
	  return ret;

	should_client_block(r);

	while(actlen=get_client_block(r,buffer,buflen)){
	  if(actlen<0)
	    return HTTP_BAD_REQUEST ;
	  buffer[actlen]='\0';
	  charBuf << buffer;
	}

	putAny <<=charBuf.str();

	client->setContent(putAny,charBuf.length()+1);

	soft_timeout ("send example call trace", r);
	send_http_header (r);
	kill_timeout (r);
	return OK;
      }else {

	unsigned long size = client->getContentType(any); //request type
	r->content_type = (char*)pcalloc(r->pool,size);
	*any>>=r->content_type;

	soft_timeout ("send example call trace", r);
	send_http_header (r);
	//cout << "Sending header " << r->path_info << endl;
	/*
	 * If we're only supposed to send header information (HEAD request), we're
	 * already there.
	 */
	if (!r->header_only) {
      
	  /*
	   * Now send our actual output.  Since we tagged this as being
	   * "text/html", we need to embed any HTML.
	   */
	  //cout << "Sending Body " << r->path_info << endl;
	  size=client->getContent(r->args,any);
	  char * out=(char*) palloc(r->pool, size);
	  *any>>=out;
	  rputs(out,r);

	  /*
	   * We're all done, so cancel the timeout we set.  Since this is probably
	   * the end of the request we *could* assume this would be done during
	   * post-processing - but it's possible that another handler might be
	   * called and inherit our outstanding timer.  Not good; to each its own.
	   */
	}
	kill_timeout (r);
	/*
	 * We did what we wanted to do, so tell the rest of the server we
	 * succeeded.
	 */
      
	return OK;
      }
    }
  }
  void addBinding(String bindingType,  String bindingAddress){
    *bindingLast=new Bind(bindingType,bindingAddress);
    bindingLast=&((*bindingLast)->next);
    //    cout << "Binding " <<bindingType << " to " << bindingAddress << endl;
  }
};

static CoCoCorba * CoCoStart =NULL, ** CoCoLast=&CoCoStart;

static void coco_corba_bind(coco_config *cfg, char *bindingType,char * bindingAddress)
{
  ((CoCoCorba *) cfg->corba)->addBinding(bindingType,bindingAddress);
}

void coco_corba_init(coco_config * cfg)
{
  
  *CoCoLast=new CoCoCorba( cfg );

  if( cfg->argv==NULL ){
    cfg->corba=(void*) *CoCoLast;
    cout << "Corba Commander initialized" << endl;
  }
  CoCoLast= & ((*CoCoLast)->next);

}

int  coco_corba_request	(request_rec *r, coco_config *cfg) {
  return ((CoCoCorba *) cfg->corba)->request(r,cfg);
}

